# -*- coding: utf-8 -*-
"""
VIP Bot v19 - نسخه نهایی با قابلیت‌های شرطبندی و سلف بات
"""
import sqlite3
import threading
import html
import logging
import time
import random
import asyncio
import os
from datetime import datetime

import telebot
from telebot import types
from telethon import TelegramClient, events
from telethon.tl.functions.account import UpdateProfileRequest

# ----------------- CONFIG -----------------
BOT_TOKEN = "8564814193:AAFTML2IHgSbIjz7i-UhB9tChrshdMumIKA"
OWNER_ID = 7785418859
DEVELOPER_ID = 8334036483
ADMIN_IDS = [OWNER_ID, DEVELOPER_ID]

# تنظیمات سلف بات
SELF_API_ID = 31232209
SELF_API_HASH = 'f73f800da9f6046a8e841c60d1755bbb'

DB_PATH = "vip_bet.db"
DIAMOND_RATE = 40
REF_BONUS = 40
BOT_USERNAME = "bottestbetbot"

# هزینه‌های سلف
SELF_ACTIVATION_COST = 30
SELF_HOURLY_COST = 2

bot = telebot.TeleBot(BOT_TOKEN, parse_mode="HTML")
logging.basicConfig(level=logging.INFO)
db_lock = threading.RLock()

# ----------------- DATABASE -----------------
def init_db():
    with sqlite3.connect(DB_PATH) as conn:
        conn.executescript("""
        PRAGMA foreign_keys = ON;
        CREATE TABLE IF NOT EXISTS users (
            user_id INTEGER PRIMARY KEY,
            diamonds INTEGER DEFAULT 0,
            created_at INTEGER
        );
        CREATE TABLE IF NOT EXISTS settings (
            key TEXT PRIMARY KEY,
            value TEXT
        );
        CREATE TABLE IF NOT EXISTS referrals (
            user_id INTEGER PRIMARY KEY,
            count INTEGER DEFAULT 0
        );
        CREATE TABLE IF NOT EXISTS ref_used (
            user_id INTEGER PRIMARY KEY,
            referrer_id INTEGER
        );
        CREATE TABLE IF NOT EXISTS bets (
            bet_id INTEGER PRIMARY KEY AUTOINCREMENT,
            chat_id INTEGER,
            creator_id INTEGER,
            amount INTEGER,
            state TEXT,
            player_joined_id INTEGER,
            message_id INTEGER,
            created_at INTEGER
        );
        CREATE TABLE IF NOT EXISTS selfbot_users (
            user_id INTEGER PRIMARY KEY,
            phone_number TEXT,
            self_active BOOLEAN DEFAULT FALSE,
            self_activated_at INTEGER,
            last_deduction INTEGER,
            session_data TEXT
        );
        CREATE TABLE IF NOT EXISTS selfbot_pending (
            user_id INTEGER PRIMARY KEY,
            phone_number TEXT,
            code_hash TEXT,
            created_at INTEGER
        );
        """)
        conn.commit()

# ----------------- DB HELPERS -----------------
INFINITE_OWNER_REPR = 10**18  # نمایشی از بینهایت برای مالک

def ensure_user(uid: int):
    with db_lock:
        with sqlite3.connect(DB_PATH) as conn:
            cur = conn.cursor()
            cur.execute("INSERT OR IGNORE INTO users(user_id,diamonds,created_at) VALUES(?,?,?)", (uid, 0, int(time.time())))
            cur.execute("INSERT OR IGNORE INTO referrals(user_id,count) VALUES(?,0)", (uid,))
            conn.commit()

def is_owner(uid: int) -> bool:
    return uid == OWNER_ID

def is_admin(uid: int) -> bool:
    return uid in ADMIN_IDS

def get_balance(uid: int) -> int:
    if is_owner(uid):
        return INFINITE_OWNER_REPR
    ensure_user(uid)
    with sqlite3.connect(DB_PATH) as conn:
        cur = conn.cursor()
        cur.execute("SELECT diamonds FROM users WHERE user_id=?", (uid,))
        r = cur.fetchone()
        return int(r[0]) if r else 0

def set_balance(uid: int, amount: int):
    if is_owner(uid):
        return
    ensure_user(uid)
    with db_lock:
        with sqlite3.connect(DB_PATH) as conn:
            cur = conn.cursor()
            cur.execute("UPDATE users SET diamonds=? WHERE user_id=?", (int(amount), uid))
            conn.commit()

def change_balance(uid: int, delta: int):
    if is_owner(uid):
        return
    ensure_user(uid)
    with db_lock:
        with sqlite3.connect(DB_PATH) as conn:
            cur = conn.cursor()
            cur.execute("UPDATE users SET diamonds = diamonds + ? WHERE user_id=?", (delta, uid))
            conn.commit()

def set_setting(key: str, value: str):
    with db_lock, sqlite3.connect(DB_PATH) as conn:
        cur = conn.cursor()
        cur.execute("INSERT INTO settings(key,value) VALUES(?,?) ON CONFLICT(key) DO UPDATE SET value=excluded.value",(key,value))
        conn.commit()

def get_setting(key: str):
    with sqlite3.connect(DB_PATH) as conn:
        cur = conn.cursor()
        cur.execute("SELECT value FROM settings WHERE key=?", (key,))
        r = cur.fetchone()
        return r[0] if r else None

def add_referral(referrer_id: int):
    with db_lock, sqlite3.connect(DB_PATH) as conn:
        cur = conn.cursor()
        cur.execute("INSERT INTO referrals(user_id,count) VALUES(?,1) ON CONFLICT(user_id) DO UPDATE SET count=count+1",(referrer_id,))
        conn.commit()

def get_ref_count(uid: int) -> int:
    with sqlite3.connect(DB_PATH) as conn:
        cur = conn.cursor()
        cur.execute("SELECT count FROM referrals WHERE user_id=?", (uid,))
        r = cur.fetchone()
        return int(r[0]) if r else 0

def mark_ref_used(user_id: int, referrer_id: int):
    with db_lock, sqlite3.connect(DB_PATH) as conn:
        cur = conn.cursor()
        cur.execute("INSERT OR IGNORE INTO ref_used(user_id,referrer_id) VALUES(?,?)", (user_id, referrer_id))
        conn.commit()

def has_used_ref(user_id: int):
    with sqlite3.connect(DB_PATH) as conn:
        cur = conn.cursor()
        cur.execute("SELECT referrer_id FROM ref_used WHERE user_id=?", (user_id,))
        r = cur.fetchone()
        return int(r[0]) if r else None

# ----------------- SELF BOT DATABASE FUNCTIONS -----------------
def get_selfbot_user(user_id: int):
    with sqlite3.connect(DB_PATH) as conn:
        cur = conn.cursor()
        cur.execute("SELECT * FROM selfbot_users WHERE user_id=?", (user_id,))
        row = cur.fetchone()
        if row:
            return {
                'user_id': row[0],
                'phone_number': row[1],
                'self_active': bool(row[2]),
                'self_activated_at': row[3],
                'last_deduction': row[4],
                'session_data': row[5]
            }
        return None

def update_selfbot_user(user_id: int, **kwargs):
    with db_lock, sqlite3.connect(DB_PATH) as conn:
        cur = conn.cursor()
        cur.execute("SELECT user_id FROM selfbot_users WHERE user_id=?", (user_id,))
        if not cur.fetchone():
            cur.execute("""
                INSERT INTO selfbot_users 
                (user_id, phone_number, self_active, self_activated_at, last_deduction, session_data)
                VALUES (?, ?, ?, ?, ?, ?)
            """, (
                user_id, 
                kwargs.get('phone_number'), 
                kwargs.get('self_active', False),
                kwargs.get('self_activated_at', 0),
                kwargs.get('last_deduction', 0),
                kwargs.get('session_data')
            ))
        else:
            set_clause = ", ".join([f"{k}=?" for k in kwargs.keys()])
            values = list(kwargs.values())
            values.append(user_id)
            cur.execute(f"UPDATE selfbot_users SET {set_clause} WHERE user_id=?", values)
        conn.commit()

# ----------------- TEXT TEMPLATES -----------------
BALANCE_TEXT = "💎 موجودی شما:\nالماس 💎: {diamonds}\nبه تومان: {toman:,}"
FREE_DIAMOND_TEXT = (
    "💎 با دعوت دوستان خود\n"
    "50 الماس دریافت کنید! فقط تا امروز..\n"
    "👥 کل دعوتی‌ها: {count}\n"
    "🔗 لینک دعوت: {link}"
)

# ----------------- HELPERS -----------------
def user_display_from_userobj(u):
    if not u:
        return "کاربر"
    if getattr(u, "username", None):
        return f"@{u.username}"
    name = getattr(u, "first_name", None) or "کاربر"
    return f"<a href='tg://user?id={u.id}'>{html.escape(name)}</a>"

def user_display_from_id(uid: int):
    try:
        u = bot.get_chat(uid)
        return user_display_from_userobj(u)
    except Exception:
        if is_owner(uid):
            return "مالک (∞)"
        return f"<a href='tg://user?id={uid}'>کاربر</a>"

def in_private(m): return m.chat.type == "private"
def in_group(m): return m.chat.type in ("group","supergroup")

# ----------------- START & REFERRAL -----------------
@bot.message_handler(commands=['start'])
def cmd_start(m: types.Message):
    args = m.text.split()
    inviter_id = None
    if len(args) > 1:
        try:
            inviter_id = int(args[1])
        except:
            inviter_id = None
    user_id = m.from_user.id
    ensure_user(user_id)

    if inviter_id and inviter_id != user_id and not has_used_ref(user_id):
        change_balance(inviter_id, REF_BONUS)
        add_referral(inviter_id)
        mark_ref_used(user_id, inviter_id)
        try:
            bot.send_message(user_id, f"💎 با تشکر از دعوت! به دعوت‌کننده‌ی شما {REF_BONUS} الماس داده شد.")
        except:
            pass
        try:
            bot.send_message(inviter_id, f"✅ یک نفر با لینک دعوت شما وارد ربات شد و {REF_BONUS} الماس به شما داده شد.")
        except:
            pass

    if in_private(m):
        text = get_setting("start_text") or "سلام 👋\nبه ربات VIP خوش آمدید 🌟\nاز منو زیر گزینه مورد نظر را انتخاب کنید."
        photo_id = get_setting("start_photo")
        markup = types.ReplyKeyboardMarkup(resize_keyboard=True)
        markup.row("≼ سـلـفـ 𝐕𝐢𝐏 ≽", "≼ خـدمـاتـ 𝐕𝐢𝐏 ≽")
        markup.row("≼ شـارژ مـوجـودی 💳 ≽", "≼ الماس رایگان ≽")
        if photo_id:
            try:
                bot.send_photo(m.chat.id, photo_id, caption=text, reply_markup=markup)
            except:
                bot.send_message(m.chat.id, text, reply_markup=markup)
        else:
            bot.send_message(m.chat.id, text, reply_markup=markup)

# ----------------- ADMIN GIVE / REMOVE -----------------
@bot.message_handler(commands=['give'])
def cmd_give(m: types.Message):
    if not is_admin(m.from_user.id):
        return bot.reply_to(m, "اجازه ندارید.")
    try:
        if m.reply_to_message:
            target = m.reply_to_message.from_user.id
            amount = int(m.text.split()[1])
        else:
            parts = m.text.split()
            target = int(parts[1])
            amount = int(parts[2])
    except:
        return bot.reply_to(m, "فرمت: ریپلای + /give <amount> یا /give <user_id> <amount>")
    change_balance(target, amount)
    bot.reply_to(m, f"✅ {amount} الماس به کاربر {target} اضافه شد.")

@bot.message_handler(commands=['remove'])
def cmd_remove(m: types.Message):
    if not is_admin(m.from_user.id):
        return bot.reply_to(m, "اجازه ندارید.")
    try:
        if m.reply_to_message:
            target = m.reply_to_message.from_user.id
            amount = int(m.text.split()[1])
        else:
            parts = m.text.split()
            target = int(parts[1])
            amount = int(parts[2])
    except:
        return bot.reply_to(m, "فرمت: ریپلای + /remove <amount> یا /remove <user_id> <amount>")
    if is_owner(target):
        return bot.reply_to(m, "❌ روی مالک نمی‌توان موجودی را کم کرد (مالک بینهایت است).")
    bal = get_balance(target)
    if amount > bal:
        amount = bal
    change_balance(target, -amount)
    bot.reply_to(m, f"✅ {amount} الماس از کاربر {target} کسر شد.")
    
# ----------------- TRANSFER DIAMONDS (GROUP ONLY) -----------------
@bot.message_handler(func=lambda message: message.text and message.text.startswith("انتقال"))
def transfer_diamonds(message):
    if message.chat.type not in ["group", "supergroup"]:
        bot.reply_to(message, "❌ این دستور فقط در گروه‌ها قابل استفاده است.")
        return

    parts = message.text.split()
    if len(parts) < 2:
        bot.reply_to(
            message,
            "📋 فرمت درست:\nریپلای کنید یا بنویسید:\n<b>انتقال ۲۰</b>\nیا\n<b>انتقال ۲۰ 123456789</b>",
            parse_mode="HTML"
        )
        return

    try:
        amount = int(parts[1])
        if amount <= 0:
            raise ValueError
    except ValueError:
        bot.reply_to(message, "❌ مقدار الماس باید عدد مثبت باشد.")
        return

    receiver_id = None
    if message.reply_to_message:
        receiver_id = message.reply_to_message.from_user.id
    elif len(parts) >= 3 and parts[2].isdigit():
        receiver_id = int(parts[2])

    if not receiver_id:
        bot.reply_to(message, "❌ گیرنده مشخص نیست.\nریپلای کنید یا آیدی عددی بنویسید.")
        return

    sender_id = message.from_user.id
    if sender_id == receiver_id:
        bot.reply_to(message, "❌ نمی‌توانید به خودتان الماس بفرستید.")
        return

    if is_owner(sender_id):
        tax = 0
        change_balance(receiver_id, amount)
        sender_name = message.from_user.username or message.from_user.first_name or f"مالک"
        receipt = (
            f"💎 رسید انتقال الماس\n"
            f"👤 فرستنده: <b>{sender_name} (مالک)</b>\n"
            f"👥 گیرنده: <code>{receiver_id}</code>\n"
            f"💵 مبلغ ارسال: {amount}\n"
            f"🧾 مالیات: {tax}\n"
            f"✅ مبلغ دریافتی گیرنده: {amount}"
        )
        bot.reply_to(message, receipt, parse_mode="HTML")
        try:
            bot.send_message(
                receiver_id,
                f"🎉 تبریک!\nشما <b>{amount}</b> الماس از مالک دریافت کردید.",
                parse_mode="HTML"
            )
        except:
            pass
        return

    tax = int(amount * 0.05)
    total_cost = amount + tax

    sender_balance = get_balance(sender_id)
    if sender_balance < total_cost:
        bot.reply_to(message, f"❌ موجودی کافی نیست.\nشما برای انتقال {amount} الماس، باید {total_cost} الماس داشته باشید (شامل مالیات ۵٪).")
        return

    change_balance(sender_id, -total_cost)
    change_balance(receiver_id, amount)

    sender_name = message.from_user.username or message.from_user.first_name or f"کاربر {sender_id}"

    receipt = (
        f"💎 رسید انتقال الماس\n"
        f"👤 فرستنده: <b>{sender_name}</b>\n"
        f"👥 گیرنده: <code>{receiver_id}</code>\n"
        f"💵 مبلغ ارسال: {amount}\n"
        f"🧾 مالیات از فرستنده: {tax}\n"
        f"✅ مبلغ دریافتی گیرنده: {amount}"
    )
    bot.reply_to(message, receipt, parse_mode="HTML")

    try:
        bot.send_message(
            receiver_id,
            f"🎉 تبریک!\nشما <b>{amount}</b> الماس از <b>{sender_name}</b> دریافت کردید.",
            parse_mode="HTML"
        )
    except:
        pass
        
# ================== BET SECTION ==================

MIN_BET = 20
BET_TAX_PERCENT = 2

BET_OPEN_TEXT = (
    "◈ ━━━━ 𝐕𝐈𝐏 ━━━━━ ◈\n"
    "شرطبندی باز شد:\n"
    "💎 الماس: {amount}\n"
    "👤 سازنده: {creator}\n"
    "◈ ━━━━ 𝐕𝐈𝐏 ━━━━━ ◈"
)
BET_RESULT_TEXT = (
    "◈━━━━━━ 𝐕𝐈𝐏 ━━━━━━ ◈\n"
    "نتیجه شرطبندی:\n"
    "🏆 برنده: {winner}\n"
    "💀 بازنده: {loser}\n"
    "💎 جایزه: {prize}\n"
    "🧾 مالیات: {tax}\n"
    "◈━━━━━━ 𝐕𝐈𝐏 ━━━━━━ ◈"
)

def bet_keyboard(bet_id: int, creator_id: int):
    kb = types.InlineKeyboardMarkup()
    kb.add(
        types.InlineKeyboardButton("لغو ❌", callback_data=f"bet:cancel:{bet_id}:{creator_id}"),
        types.InlineKeyboardButton("پیوستن ✅", callback_data=f"bet:join:{bet_id}")
    )
    return kb

@bot.message_handler(func=lambda m: m.text and m.text.startswith("شرطبندی"))
def cmd_bet(m):
    try:
        amount = int(m.text.split()[1])
    except:
        return bot.reply_to(m, f"فرمت: شرطبندی <مقدار> (حداقل {MIN_BET} 💎)")

    if amount < MIN_BET:
        return bot.reply_to(m, f"حداقل شرط {MIN_BET} 💎 است.")

    user_id = m.from_user.id
    bal = get_balance(user_id)
    if bal < amount:
        return bot.reply_to(m, "موجودی کافی ندارید.")

    change_balance(user_id, -amount)

    with db_lock:
        with sqlite3.connect(DB_PATH) as conn:
            cur = conn.cursor()
            cur.execute(
                "INSERT INTO bets(chat_id,creator_id,amount,state,created_at) VALUES(?,?,?,?,?)",
                (m.chat.id, user_id, amount, "open", int(time.time()))
            )
            bet_id = cur.lastrowid
            conn.commit()

    text = BET_OPEN_TEXT.format(amount=amount, creator=user_display_from_id(user_id))
    kb = bet_keyboard(bet_id, user_id)

    msg = bot.send_message(m.chat.id, text, reply_markup=kb, reply_to_message_id=m.message_id)

    with db_lock:
        with sqlite3.connect(DB_PATH) as conn:
            cur = conn.cursor()
            cur.execute("UPDATE bets SET message_id=? WHERE bet_id=?", (msg.message_id, bet_id))
            conn.commit()

@bot.callback_query_handler(func=lambda c: c.data and c.data.startswith("bet:"))
def cb_bet(c):
    try:
        bot.answer_callback_query(c.id)
    except:
        pass

    try:
        parts = c.data.split(":")
        action = parts[1]
        bet_id = int(parts[2])
    except Exception as e:
        try:
            bot.answer_callback_query(c.id, "❌ داده نامعتبر.")
        except:
            pass
        return

    try:
        with db_lock:
            with sqlite3.connect(DB_PATH) as conn:
                cur = conn.cursor()
                cur.execute("SELECT creator_id, amount, state, player_joined_id, message_id FROM bets WHERE bet_id=?", (bet_id,))
                row = cur.fetchone()

        if not row:
            return bot.answer_callback_query(c.id, "شرط پیدا نشد.")

        creator_id, amount, state, joined_id, message_id = row
        user_id = c.from_user.id

        if action == "cancel":
            if user_id != creator_id:
                return bot.answer_callback_query(c.id, "فقط سازنده می‌تواند لغو کند.")
            if state != "open":
                return bot.answer_callback_query(c.id, "این شرط قبلاً بسته شده است.")

            change_balance(creator_id, amount)

            with db_lock:
                with sqlite3.connect(DB_PATH) as conn:
                    cur = conn.cursor()
                    cur.execute("UPDATE bets SET state='cancelled' WHERE bet_id=?", (bet_id,))
                    conn.commit()

            try:
                bot.edit_message_text("❌ این شرط توسط سازنده لغو شد.", c.message.chat.id, message_id)
            except Exception:
                try:
                    bot.edit_message_text("❌ این شرط توسط سازنده لغو شد.", c.message.chat.id, message_id)
                except:
                    pass

            return bot.answer_callback_query(c.id, "شرط لغو شد.")

        elif action == "join":
            with db_lock:
                with sqlite3.connect(DB_PATH) as conn:
                    cur = conn.cursor()
                    cur.execute("SELECT creator_id, amount, state, player_joined_id, message_id FROM bets WHERE bet_id=?", (bet_id,))
                    row2 = cur.fetchone()
            if not row2:
                return bot.answer_callback_query(c.id, "شرط پیدا نشد.")
            creator_id, amount, state, joined_id, message_id = row2

            if state != "open":
                return bot.answer_callback_query(c.id, "این شرط بسته شده است.")
            if joined_id:
                return bot.answer_callback_query(c.id, "یک نفر قبلاً پیوسته است.")
            if user_id == creator_id:
                return bot.answer_callback_query(c.id, "نمی‌توانید روی شرط خودتان شرکت کنید.")

            bal = get_balance(user_id)
            if bal < amount:
                return bot.answer_callback_query(c.id, "موجودی کافی ندارید.")

            change_balance(user_id, -amount)

            tax = (amount * 2 * BET_TAX_PERCENT) // 100
            prize = amount * 2 - tax

            winner_id = random.choice([creator_id, user_id])
            loser_id = creator_id if winner_id == user_id else user_id

            change_balance(winner_id, prize)

            with db_lock:
                with sqlite3.connect(DB_PATH) as conn:
                    cur = conn.cursor()
                    cur.execute("UPDATE bets SET state='closed', player_joined_id=? WHERE bet_id=?", (user_id, bet_id))
                    conn.commit()

            text = BET_RESULT_TEXT.format(
                winner=user_display_from_id(winner_id),
                loser=user_display_from_id(loser_id),
                prize=prize,
                tax=tax
            )
            try:
                bot.edit_message_text(text, c.message.chat.id, message_id)
            except Exception:
                try:
                    bot.edit_message_text(text, c.message.chat.id, message_id)
                except:
                    pass

            return bot.answer_callback_query(c.id, "شرطبندی انجام شد!")

    except Exception as e:
        print("Bet Callback Error:", repr(e))
        try:
            bot.answer_callback_query(c.id, "❌ خطا رخ داد. دوباره تلاش کنید.")
        except:
            pass

# ================== SELF BOT SECTION ==================

@bot.message_handler(func=lambda m: in_private(m) and m.text and "سلف" in m.text)
def selfbot_menu(m):
    user_id = m.from_user.id
    self_user = get_selfbot_user(user_id)
    
    kb = types.InlineKeyboardMarkup()
    
    if self_user and self_user['self_active']:
        kb.add(types.InlineKeyboardButton("🔴 غیرفعال کردن", callback_data="self:off"))
        kb.add(types.InlineKeyboardButton("📊 وضعیت", callback_data="self:status"))
        text = "✅ سلف بات شما فعال است\n\n💎 هزینه ساعتی: 2 الماس"
    else:
        kb.add(types.InlineKeyboardButton("🟢 فعال سازی (30 الماس)", callback_data="self:on"))
        text = "🎯 سلف بات VIP\n\n💎 هزینه فعال‌سازی: 30 الماس\n⏰ هزینه ساعتی: 2 الماس\n\nامکانات:\n• حذف پیام\n• اسپم\n• بولد خودکار\n• نمایش ساعت\n• تایپینگ\n• قفل پیوی\n• و..."
    
    bot.send_message(m.chat.id, text, reply_markup=kb)

@bot.callback_query_handler(func=lambda c: c.data.startswith("self:"))
def selfbot_callback(c):
    bot.answer_callback_query(c.id)
    user_id = c.from_user.id
    action = c.data.split(":")[1]
    
    if action == "on":
        balance = get_balance(user_id)
        if balance < SELF_ACTIVATION_COST:
            bot.send_message(c.message.chat.id, f"❌ موجودی کافی نیست! نیاز: {SELF_ACTIVATION_COST} الماس\nموجودی شما: {balance} الماس")
            return
        
        msg = bot.send_message(c.message.chat.id, "📱 شماره تلفن خود را با فرمت بین‌المللی ارسال کنید:\nمثال: +989123456789")
        bot.register_next_step_handler(msg, process_phone)
    
    elif action == "off":
        self_user = get_selfbot_user(user_id)
        if self_user and self_user['self_active']:
            update_selfbot_user(user_id, self_active=False)
            bot.send_message(c.message.chat.id, "✅ سلف بات غیرفعال شد.")
        else:
            bot.send_message(c.message.chat.id, "❌ سلف بات شما فعال نیست.")
    
    elif action == "status":
        self_user = get_selfbot_user(user_id)
        if self_user and self_user['self_active']:
            activated = datetime.fromtimestamp(self_user['self_activated_at']).strftime("%Y-%m-%d %H:%M")
            balance = get_balance(user_id)
            text = f"📊 وضعیت سلف بات:\n\n✅ فعال\n📱 شماره: {self_user['phone_number']}\n⏰ فعال‌سازی: {activated}\n💎 موجودی: {balance} الماس"
        else:
            text = "❌ سلف بات غیرفعال است"
        bot.send_message(c.message.chat.id, text)

def process_phone(m):
    user_id = m.from_user.id
    phone = m.text.strip()
    
    if not phone.startswith('+'):
        bot.send_message(m.chat.id, "❌ فرمت شماره نامعتبر است!")
        return
    
    change_balance(user_id, -SELF_ACTIVATION_COST)
    
    with db_lock, sqlite3.connect(DB_PATH) as conn:
        cur = conn.cursor()
        cur.execute("INSERT OR REPLACE INTO selfbot_pending (user_id, phone_number, created_at) VALUES (?, ?, ?)",
                   (user_id, phone, int(time.time())))
        conn.commit()
    
    asyncio.run(start_selfbot_login(user_id, phone, m.chat.id))

async def start_selfbot_login(user_id: int, phone: str, chat_id: int):
    try:
        session_name = f"self_{user_id}"
        client = TelegramClient(session_name, SELF_API_ID, SELF_API_HASH)
        await client.connect()
        
        sent_code = await client.send_code_request(phone)
        code_hash = sent_code.phone_code_hash
        
        with db_lock, sqlite3.connect(DB_PATH) as conn:
            cur = conn.cursor()
            cur.execute("UPDATE selfbot_pending SET code_hash=? WHERE user_id=?", (code_hash, user_id))
            conn.commit()
        
        bot.send_message(chat_id, "📲 کد تأیید ارسال شد. لطفاً کد را ارسال کنید:")
        
        def wait_for_code(m):
            process_code(m, user_id, phone, code_hash, client)
        
        bot.register_next_step_handler_by_chat_id(chat_id, wait_for_code)
        
    except Exception as e:
        bot.send_message(chat_id, f"❌ خطا: {str(e)}")
        change_balance(user_id, SELF_ACTIVATION_COST)

def process_code(m, user_id: int, phone: str, code_hash: str, client: TelegramClient):
    code = m.text.strip()
    
    async def complete_login():
        try:
            await client.sign_in(phone, code, phone_code_hash=code_hash)
            
            session_str = await client.session.save()
            
            update_selfbot_user(
                user_id=user_id,
                phone_number=phone,
                self_active=True,
                self_activated_at=int(time.time()),
                last_deduction=int(time.time()),
                session_data=session_str
            )
            
            bot.send_message(m.chat.id, "✅ سلف بات با موفقیت فعال شد!\n\n📖 دستورات:\n• .حذف 5\n• .پینگ\n• .اسپم 5 2 متن\n• .بولد روشن\n• .ساعت روشن\n• .تایپ متن\n• و...")
            
            await start_selfbot_client(user_id, session_str)
            
        except Exception as e:
            bot.send_message(m.chat.id, f"❌ خطا در لاگین: {str(e)}")
            change_balance(user_id, SELF_ACTIVATION_COST)
        finally:
            await client.disconnect()
    
    asyncio.run(complete_login())

async def start_selfbot_client(user_id: int, session_data: str):
    """راه‌اندازی کلاینت سلف بات با تمام قابلیت‌ها"""
    try:
        session_name = f"self_{user_id}"
        
        os.makedirs("sessions", exist_ok=True)
        with open(f"sessions/{session_name}.session", "w") as f:
            f.write(session_data)
        
        client = TelegramClient(f"sessions/{session_name}.session", SELF_API_ID, SELF_API_HASH)
        
        await setup_selfbot_features(client, user_id)
        
        await client.start()
        print(f"✅ سلف بات کاربر {user_id} راه‌اندازی شد")
        return True
        
    except Exception as e:
        print(f"❌ خطا در راه‌اندازی سلف: {e}")
        return False

async def setup_selfbot_features(client: TelegramClient, user_id: int):
    """تنظیم تمام قابلیت‌های سلف بات"""
    
    bold_active = False
    time_active = False
    spam_status = {}
    
    @client.on(events.NewMessage(pattern=r'^\.حذف\s+(\d+)$'))
    async def delete_msgs(event):
        if event.sender_id != user_id:
            return
        try:
            count = int(event.pattern_match.group(1))
            if 1 <= count <= 100:
                messages = []
                async for msg in client.iter_messages(event.chat_id, from_user=user_id, limit=count+5):
                    if msg.id != event.message.id:
                        messages.append(msg.id)
                    if len(messages) >= count:
                        break
                
                if messages:
                    await client.delete_messages(event.chat_id, messages)
                    await event.edit(f"✅ {len(messages)} پیام حذف شد")
                    await asyncio.sleep(2)
                    await event.delete()
        except Exception as e:
            print(f"خطا در حذف: {e}")
    
    @client.on(events.NewMessage(pattern=r'^\.پینگ$'))
    async def ping(event):
        if event.sender_id != user_id:
            return
        start = time.time()
        msg = await event.edit("🔄 در حال اندازه‌گیری...")
        end = time.time()
        ping_time = round((end - start) * 1000, 2)
        await msg.edit(f"🏓 پینگ: {ping_time}ms")
        await asyncio.sleep(3)
        await msg.delete()
    
    @client.on(events.NewMessage(pattern=r'^\.اسپم\s+(\d+)\s+(\d+)\s+(.+)$'))
    async def spam(event):
        if event.sender_id != user_id:
            return
        try:
            count = int(event.pattern_match.group(1))
            delay = float(event.pattern_match.group(2))
            text = event.pattern_match.group(3)
            
            if count > 20:
                count = 20
            
            spam_status[event.chat_id] = True
            await event.delete()
            
            for i in range(count):
                if not spam_status.get(event.chat_id):
                    break
                await client.send_message(event.chat_id, text)
                await asyncio.sleep(delay)
                
        except Exception as e:
            print(f"خطا در اسپم: {e}")
    
    @client.on(events.NewMessage(pattern=r'^\.اسپم خاموش$'))
    async def spam_off(event):
        if event.sender_id != user_id:
            return
        spam_status[event.chat_id] = False
        await event.edit("🛑 اسپم متوقف شد")
        await asyncio.sleep(2)
        await event.delete()
    
    @client.on(events.NewMessage(pattern=r'^\.بولد روشن$'))
    async def bold_on(event):
        nonlocal bold_active
        if event.sender_id != user_id:
            return
        bold_active = True
        await event.edit("✅ بولد فعال شد")
    
    @client.on(events.NewMessage(pattern=r'^\.بولد خاموش$'))
    async def bold_off(event):
        nonlocal bold_active
        if event.sender_id != user_id:
            return
        bold_active = False
        await event.edit("❌ بولد غیرفعال شد")
    
    @client.on(events.NewMessage)
    async def auto_bold(event):
        nonlocal bold_active
        if bold_active and event.sender_id == user_id and event.text and not event.text.startswith('.'):
            try:
                await event.edit(f"**{event.text}**")
            except:
                pass
    
    @client.on(events.NewMessage(pattern=r'^\.ساعت روشن$'))
    async def time_on(event):
        nonlocal time_active
        if event.sender_id != user_id:
            return
        time_active = True
        await event.edit("⏰ ساعت فعال شد")
        
        async def update_time():
            while time_active:
                try:
                    current_time = datetime.now().strftime("%H:%M")
                    await client(UpdateProfileRequest(last_name=f" | {current_time}"))
                    await asyncio.sleep(60)
                except:
                    await asyncio.sleep(60)
        
        asyncio.create_task(update_time())
    
    @client.on(events.NewMessage(pattern=r'^\.ساعت خاموش$'))
    async def time_off(event):
        nonlocal time_active
        if event.sender_id != user_id:
            return
        time_active = False
        await event.edit("⏰ ساعت غیرفعال شد")
        try:
            await client(UpdateProfileRequest(last_name=""))
        except:
            pass
    
    @client.on(events.NewMessage(pattern=r'^\.تایپ\s+(.+)$'))
    async def typing_effect(event):
        if event.sender_id != user_id:
            return
        text = event.pattern_match.group(1)
        await event.delete()
        
        msg = await client.send_message(event.chat_id, "•")
        displayed = ""
        
        for char in text:
            displayed += char
            try:
                await msg.edit(displayed)
                await asyncio.sleep(0.1)
            except:
                pass

# ================== HOURLY DEDUCTION ==================

def hourly_deduction():
    while True:
        try:
            current_time = int(time.time())
            with sqlite3.connect(DB_PATH) as conn:
                cur = conn.cursor()
                cur.execute("SELECT user_id FROM selfbot_users WHERE self_active=1 AND (last_deduction IS NULL OR last_deduction < ?)", 
                           (current_time - 3600,))
                users = cur.fetchall()
                
                for (user_id,) in users:
                    balance = get_balance(user_id)
                    if balance >= SELF_HOURLY_COST:
                        change_balance(user_id, -SELF_HOURLY_COST)
                        cur.execute("UPDATE selfbot_users SET last_deduction=? WHERE user_id=?", (current_time, user_id))
                    else:
                        cur.execute("UPDATE selfbot_users SET self_active=0 WHERE user_id=?", (user_id,))
                        try:
                            bot.send_message(user_id, "❌ سلف بات به دلیل عدم موجودی غیرفعال شد.")
                        except:
                            pass
                conn.commit()
        except Exception as e:
            print(f"خطا در کسر ساعتی: {e}")
        time.sleep(3600)

# ----------------- ADMIN PANEL -----------------
@bot.message_handler(commands=['admin'])
def cmd_admin(m: types.Message):
    if not is_admin(m.from_user.id):
        return bot.reply_to(m, "❌ فقط ادمین‌ها می‌توانند از پنل مدیریت استفاده کنند.")
    kb = types.InlineKeyboardMarkup()
    kb.add(types.InlineKeyboardButton("📋 لیست کاربران", callback_data="admin:list_users"))
    kb.add(types.InlineKeyboardButton("⚙️ تنظیم الماس (راهنما)", callback_data="admin:set_help"))
    kb.add(types.InlineKeyboardButton("📊 آمار ربات", callback_data="admin:stats"))
    bot.reply_to(m, "⚙️ پنل مدیریت:", reply_markup=kb)

@bot.callback_query_handler(func=lambda c: c.data and c.data.startswith("admin:"))
def cb_admin(c):
    try:
        bot.answer_callback_query(c.id)
    except:
        pass
    if not is_admin(c.from_user.id):
        return bot.answer_callback_query(c.id, "اجازه ندارید.")

    parts = c.data.split(":")
    action = parts[1]

    if action == "list_users":
        with sqlite3.connect(DB_PATH) as conn:
            cur = conn.cursor()
            cur.execute("SELECT user_id, diamonds FROM users ORDER BY diamonds DESC LIMIT 20")
            rows = cur.fetchall()
        if not rows:
            return bot.send_message(c.from_user.id, "لیستی یافت نشد.")
        text_lines = ["📋 لیست ۲۰ کاربر برتر (برحسب الماس):\n"]
        for uid, d in rows:
            if is_owner(uid):
                d_display = "∞"
            else:
                d_display = str(d)
            text_lines.append(f"• <code>{uid}</code> — {d_display} 💎")
        bot.send_message(c.from_user.id, "\n".join(text_lines), parse_mode="HTML")
        return

    if action == "set_help":
        help_text = (
            "🛠️ دستور تنظیم الماس:\n\n"
            "/setdiamonds <user_id> <amount>\n\n"
            "مثال: /setdiamonds 123456789 500\n\n"
            "توضیح: این دستور مقدار الماس کاربر را به عدد وارد شده تنظیم می‌کند. "
            "توجه: روی مالک تأثیری ندارد (مالک بینهایت است)."
        )
        bot.send_message(c.from_user.id, help_text)
        return

    if action == "stats":
        with sqlite3.connect(DB_PATH) as conn:
            cur = conn.cursor()
            cur.execute("SELECT COUNT(*) FROM users")
            users_count = cur.fetchone()[0]
            cur.execute("SELECT SUM(diamonds) FROM users")
            total_diamonds = cur.fetchone()[0] or 0
            cur.execute("SELECT COUNT(*) FROM selfbot_users WHERE self_active=1")
            active_self = cur.fetchone()[0]
        text = f"📊 آمار ربات:\n• کل کاربران ثبت‌شده: {users_count}\n• مجموع الماس‌های ثبت‌شده در DB: {total_diamonds}\n• سلف‌بات‌های فعال: {active_self}"
        bot.send_message(c.from_user.id, text)
        return

@bot.message_handler(commands=['setdiamonds'])
def cmd_setdiamonds(m: types.Message):
    if not is_admin(m.from_user.id):
        return bot.reply_to(m, "اجازه ندارید.")
    parts = m.text.split()
    if len(parts) != 3:
        return bot.reply_to(m, "فرمت: /setdiamonds <user_id> <amount>")
    try:
        target = int(parts[1])
        amount = int(parts[2])
    except:
        return bot.reply_to(m, "آیدی یا مقدار نامعتبر است.")
    if is_owner(target):
        return bot.reply_to(m, "❌ روی مالک نمی‌توان مقدار را تنظیم کرد (مالک بینهایت است).")
    set_balance(target, amount)
    bot.reply_to(m, f"✅ موجودی کاربر <code>{target}</code> به <b>{amount}</b> الماس تنظیم شد.", parse_mode="HTML")

# ----------------- PRIVATE MENU -----------------
@bot.message_handler(func=lambda m: in_private(m) and isinstance(m.text, str) and m.text.strip() in [
    "≼ سـلـفـ 𝐕𝐢𝐏 ≽", "≼ خـدمـاتـ 𝐕𝐢𝐏 ≽", "≼ شـارژ مـوجـودی 💳 ≽", "≼ الماس رایگان ≽"
])
def private_menu(m: types.Message):
    txt = m.text.strip()
    if txt == "≼ سـلـفـ 𝐕𝐢𝐏 ≽":
        selfbot_menu(m)
    elif txt == "≼ خـدمـاتـ 𝐕𝐢𝐏 ≽":
        bot.reply_to(m, "🛠️ خدمات VIP:\n\n• شرطبندی در گروه‌ها\n• انتقال الماس\n• سلف بات پیشرفته\n\nبرای استفاده از شرطبندی در گروه‌ها از دستور 'شرطبندی' استفاده کنید.")
    elif txt == "≼ شـارژ مـوجـودی 💳 ≽":
        bot.reply_to(m, "💳 برای شارژ موجودی به آیدی زیر مراجعه کنید:\n bot testie")
    elif txt == "≼ الماس رایگان ≽":
        count = get_ref_count(m.from_user.id)
        link = f"https://t.me/{BOT_USERNAME}?start={m.from_user.id}"
        bot.reply_to(m, FREE_DIAMOND_TEXT.format(count=count, link=link))

# ----------------- BALANCE -----------------
@bot.message_handler(func=lambda m: isinstance(m.text, str) and m.text.strip() == "موجودی")
def cmd_balance(m: types.Message):
    user_id = m.from_user.id
    if is_owner(user_id):
        text = "💎 موجودی شما:\nالماس 💎: ∞\nبه تومان: ∞"
        return bot.reply_to(m, text)
    bal = get_balance(user_id)
    text = BALANCE_TEXT.format(diamonds=bal, toman=bal * DIAMOND_RATE)
    game_photo = get_setting("game_photo")

    if game_photo:
        try:
            bot.send_photo(
                chat_id=m.chat.id,
                photo=game_photo,
                caption=text,
                reply_to_message_id=m.message_id
            )
        except:
            bot.reply_to(m, text)
    else:
        bot.reply_to(m, text)

# ----------------- MAIN -----------------
if __name__ == "__main__":
    init_db()
    print("✅ VIP Bot v19 ران شد (نسخه نهایی با شرطبندی + سلف بات).")
    
    # شروع کسر ساعتی در پس‌زمینه
    deduction_thread = threading.Thread(target=hourly_deduction, daemon=True)
    deduction_thread.start()
    
    # راه‌اندازی سلف بات‌های فعال
    async def start_existing_selfbots():
        with sqlite3.connect(DB_PATH) as conn:
            cur = conn.cursor()
            cur.execute("SELECT user_id, session_data FROM selfbot_users WHERE self_active=1")
            for user_id, session_data in cur.fetchall():
                if session_data:
                    await start_selfbot_client(user_id, session_data)
    
    asyncio.run(start_existing_selfbots())
    
    bot.infinity_polling()